function [x_axis,y_axis,z_axis] = get_ibias_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the current
prompt_current = 'enter the current module amplification (in Amps)';
dlgtitle_current = 'Input';
user_val_current = inputdlg(prompt_current,dlgtitle_current);
current_val = str2num(user_val_current{1});

%% ask for the voltage
prompt_voltage = 'enter the Vmeasure module amplification (in Volts)';
dlgtitle_voltage = 'Input';
user_val_voltage = inputdlg(prompt_voltage,dlgtitle_voltage);
voltage_val = str2num(user_val_voltage{1});


%% ask for the factor to convert Bx to Btot
prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
dlgtitle_Bx = 'Input';
user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
Bx_val = str2num(user_val_Bx{1});


%% Reading the size of Ibias
str_Ibias = char(file.textdata(6));
str_split = strsplit(str_Ibias);
size_Ibias = str2num(str_split{3});

%% Getting Ibias values
Ibias = file.data(1:size_Ibias,1)*current_val;

%% Reading the size of Bx
size_Bx = size(file.data(:,1))/size_Ibias;

%% Getting Bx
r=1;
for i=1:size_Bx(1,1)
    Bx(i)=file.data(r,2);
    r=r+size_Ibias;

end

%% Getting measured Voltage values
s=1;
Vmeasure = zeros(size_Bx(1,1),size_Ibias);
for i=1:size_Bx(1,1)
    Vmeasure(i,1:size_Ibias)=file.data(s:s+size_Ibias-1,5)*voltage_val;
    s=s+size_Ibias;
end

%% calculating the differential resistance in Ohms
dVdI = zeros(size_Bx(1,1),size_Ibias);
for i=1:size_Bx(1,1)
    for j=2:size_Ibias-1
        dVdI(i,j) = (Vmeasure(i,j+1)-Vmeasure(i,j-1))/(Ibias(j+1)-Ibias(j-1));
    end
end

figure;
x_axis = Bx/Bx_val;
y_axis = Ibias(2:end-1)*10^9; % in nA
z_axis = transpose(dVdI(:,2:end-1));
%figure1 = pcolor(x_axis,Ibias(2:end-1)*10^9,transpose(dVdI(:,end-1:-1:2)));
figure1 = pcolor(x_axis,Ibias(2:end-1)*10^9,flip(transpose(dVdI(:,2:end-1))/1000));
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
%max_value = max(max(transpose(dVdI(:,2:end-1))));
%caxis([0 2.2*10^5])
% cl.Ticks = [0 2000 4000 6000 8000 10000];
% cl.TickLabels = {'0','2000','4000','6000','8000','10000'};
cl.Label.String = 'R (k\Omega)';
xlabel('$B_{||}(T)$','Interpreter','latex')
ylabel('$I_{bias}(nA)$','Interpreter','latex');

end